 ; Ŀ
 ;   Firk - change the first letter in each selected text entity and       
 ;   attribute to a given character if it is a specific character.         
 ;   Copyright 1995, 2006 by Rocket Software Ltd.                          
 ;   The saddest thing about the cancellation of the SDI program was the   
 ;   cessation of dot-matrix machine gun development.                      
 ; 

 ; Ŀ
 ;   Isins - search and replace the first character in each attribute.     
 ; 
 (DEFUN ISINS (ch1 ch2 enam / esav entt txt chg newtxt)
  (setq esav enam)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
         (setq txt (cdr (assoc 1 entt)))
         (cond ((or (= (substr txt 1 1) ch1)
                    (and (= ch1 "*")
                         (/= (substr txt 1 2) "%%")))
                (setq chg T)
                (mark (cdr (assoc 10 entt)))
                (setq newtxt (strcat ch2 (substr txt 2)))
                (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt)))
               ((or (= (strcase (substr txt 1 4)) (strcat "%%U" ch1))
                    (and (= (strcase (substr txt 1 3)) "%%U")
                         (= ch1 "*")))
                (setq chg T)
                (mark (cdr (assoc 10 entt)))
                (setq newtxt (strcat "%%U" ch2 (substr txt 5)))
                (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt)))))
  (if chg (entupd esav))
 (princ))
 ; Ŀ
 ;   Isins end.                                                            
 ; 

 ; Ŀ
 ;   Isatt - search and replace the first character in an attdef string.   
 ; 
 (DEFUN ISATT (ch1 ch2 entt / txt newtxt)
  (setq txt (cdr (assoc 2 entt)))
  (cond ((or (= (substr txt 1 1) ch1)
             (and (= ch1 "*")
                  (/= (substr txt 1 2) "%%")))
         (mark (cdr (assoc 10 entt)))
         (setq newtxt (strcat ch2 (substr txt 2)))
         (entmod (subst (cons 2 newtxt) (assoc 2 entt) entt)))
        ((or (= (strcase (substr txt 1 4)) (strcat "%%U" ch1))
             (and (= (strcase (substr txt 1 3)) "%%U")
                  (= ch1 "*")))
         (mark (cdr (assoc 10 entt)))
         (setq newtxt (strcat "%%U" ch2 (substr txt 5)))
         (entmod (subst (cons 2 newtxt) (assoc 2 entt) entt))))
 (princ))
 ; Ŀ
 ;   Isatt end.                                                            
 ; 

 ; Ŀ
 ;   Istxt - search and replace the first character in a text string.      
 ; 
 (DEFUN ISTXT (ch1 ch2 entt / txt newtxt)
  (setq txt (cdr (assoc 1 entt)))
  (cond ((or (= (substr txt 1 1) ch1)
             (and (= ch1 "*")
                  (/= (substr txt 1 2) "%%")))
         (mark (cdr (assoc 10 entt)))
         (setq newtxt (strcat ch2 (substr txt 2)))
         (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt)))
        ((or (= (strcase (substr txt 1 4)) (strcat "%%U" ch1))
             (and (= (strcase (substr txt 1 3)) "%%U")
                  (= ch1 "*")))
         (mark (cdr (assoc 10 entt)))
         (setq newtxt (strcat "%%U" ch2 (substr txt 5)))
         (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt))))
 (princ))
 ; Ŀ
 ;   Istxt end.                                                            
 ; 

 ; Ŀ
 ;   Mark - draw a marker X at a point.                                    
 ; 
 (DEFUN MARK (pa / rad)
  (setq rad (/ (getvar "viewsize") 45))
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) 7)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) 7)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Firk.                                                                 
 ; 
 (DEFUN C:FIRK (/ ch1 ch2 ss len num enam typ entt)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq ch1 (getstring "Leading Character to Replace: "))
  (setq ch2 (getstring "With: "))
 ; Ŀ
 ;   Get a selection set of Text, Attdefs, and blocks with attributes.     
 ; 
  (prompt "Select text/blocks to change:")
  (if (setq ss (ssget '((-4 . "<or") (0 . "text")
                       (-4 . "<and") (0 . "insert") (66 . 1) (-4 . "and>")
                       (0 . "attdef") (-4 . "or>"))))
      (progn
           (setq len (strcat "/" (itoa (sslength ss))))
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (grtext -2 (strcat (itoa (setq num (1+ num))) len))
                  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
                  (cond ((= typ "TEXT")
                         (istxt ch1 ch2 entt))
                        ((= typ "ATTDEF")
                         (isatt ch1 ch2 entt))
                        ((= typ "INSERT")
                         (isins ch1 ch2 enam))))))
 (princ))